<?PHP

class agent {

	public function __construct() {
		$this->verbose = 0;
		$this->write_log_file = 0;

		$this->agent_info = $this->get_agent_info();
	}

	public function get_agent_info($agent = "") {
		$agent || $agent = $_SERVER["HTTP_USER_AGENT"];

		$agent_info = $this->parse_agent($agent);

		#print_r($agent_info);
		return $agent_info;
	}

	private function parse_agent($agentstr) {
		$verbose = $this->verbose;

		// Example: Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; m18)
		// Example: Mozilla/4.7 [en] (WinNT; I)
		// Example: Mozilla/5.0 (Windows 2000; U) Opera 5.12  [en]
		// Example: Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:0.9.3+) Gecko/20010828
		// Example: Lynx/2.8.4rel.1 libwww-FM/2.14
		// Example: Mozilla/5.0 (X11; U; Linux i686; en-US; rv:0.9.5) Gecko/20011014
		// Example: Opera/5.0 (Linux 2.4.7-10 i686; U) [en]

		# 11111111111111111111111111111111111111111
		if ( preg_match("/^(.+)\/([0-9])\.?([0-9]+).*\((.*?;)(.*?;)\s+([a-z\s]+)\s*([\d\.-]+)?(.*)/i",$agentstr,$match) ) {
			if ($verbose) { print "Matched Rule #1<br />"; }
			
			#print_r($match);
			
			$browser = trim($match[1]);
			$bversion = "$match[2].$match[3]";
			$ie = trim($match[5]);
	
			// Test for IE since it seems to be non-standard    
			if ( preg_match("/^msie\s*([\d\.]+)/i",$ie,$match2) ){
				$browser = "Internet Explorer";
				$bversion = $match2[1];
			} 
			// Check for firefox
			elseif (preg_match("/(Firefox)\/([\d\.]+)/",$agentstr,$match2)) {
				$browser = $match2[1];
				$bversion = $match2[2];
			}
			// Special Check for mozilla
			elseif (strtolower($browser) == "mozilla" && $bversion == "5.0") {
				preg_match("/.*;\s*rv:(.*?)\)/",$agentstr,$match2);
				$bversion = $match2[1];		
			} 

			if (preg_match("/AOL.*?(Windows)\s+(.+?);/",$agentstr,$match2)) {
				if ($verbose) { print "Matched the AOL subclass of rule #1<br />"; }
				$os = $match2[1];
				$osversion = $match2[2];
				
			} 
			
	
			$os || $os = trim($match[6]);
			$osversion || $osversion = trim($match[7]);
	
		}
		// Check for BeOS
		# 22222222222222222222222222222222222222222
		elseif ( preg_match("/^(.+)\/([0-9])\.?([0-9]+).*\(.*;\s*NetPositive\/(.*)\)/i",$agentstr,$match) ) {
			if ($verbose) { print "Matched Rule #2<br />"; }
			// Mozilla/3.0 (compatible; NetPositive/2.2)
			// print "You hit the BEOS section<P>";
			$browser = trim($match[1]);
			$bversion = "$match[2].$match[3]";
			$os = "BeOS";
	
			if($match[4] >=1.0 && $match[4] < 2.0) { $osversion = 3; }
			elseif($match[4] >= 2.0 && $match[4] < 2.1) { $osversion = 4; }
			elseif($match[4] >= 2.1 && $match[4] < 2.2) { $osversion = 4.5; }
			elseif($match[4] >= 2.2) { $osversion = 5.0; }			
			else { $osversion=""; }
	
		}
		// Test for non-standard agent string
		# 3333333333333333333333333333333333333333333
		elseif ( preg_match("/^(.+)\/([0-9])\.?([0-9]+).*\(([a-zA-Z]*)\s*(\d*)/i",$agentstr,$match) ) {
			if ($verbose) { print "Matched Rule #3<br />"; }
			// Mozilla/4.7 [en] (Win98; I) 
			// Example: Mozilla/5.0 (Windows 2000; U) Opera 5.12  [en]
	
			if (strstr($agentstr,"Opera") ) {
				$this->browser_check($match[1],"$match[2].$match[3]",$agentstr);
			}
			else {
				$browser = trim($match[1]);
				$bversion = "$match[2].$match[3]";
			}
	
			$os = $match[4];
			$osversion = $match[5];
	
			$this->os_check($os,$osversion,$agentstr);
		}
		// Test for Lynx
		# 444444444444444444444444444444444444444444444444444444
		elseif ( preg_match("/(Lynx)\/([\d\.]+)/",$agentstr,$match) ) {
			if ($verbose) { print "Matched Rule #4<br />"; }
			// Lynx/2.8.4rel.1 libwww-FM/2.14
			$browser = $match[1];
			$bversion = $match[2];
			$os = "Unix";
			$osversion = "Unknown";
		} elseif (preg_match("/amaya\/([\d\.]+)/",$agentstr,$match)) {
			$browser = "Amaya";
			$bversion = $match[1];

		}
		// It didn't match anything I know of, so something is wrong
		# 99 99 99 99 99 99 99 99 99 99
		else {
			if ($verbose) { print "Matched Rule #99<br />"; }
			$browser = "Unknown";
			$os = "Unknown";
			$bversion = "";
		}


		// Do some smart browser name changing
		$browser_array = $this->browser_check($browser,$bversion,$agentstr);
		$os_array = $this->os_check($os,$osversion,$agentstr);

		if ($os_array[0] == "Unknown" && $os_array[1] == "Unknown" && $browser_array[0] == "Unknown" && $browser_array[1] == "Unknown") {
			$os_array[1] = "";
			$browser_array[1] = "";
		} elseif ($os_array[0] && $os_array[1] == "Unknown") {
			$os_array[1] = "";
		} elseif ($browser_array[0] && $browser_array[1] == "Unknown") {
			$browser_array[1] = "";
		} 
	
		$this->write_log($agentstr,$os_array[0],$os_array[1],$browser_array[0],$browser_array[1]);
		$ret = array(
			'os_name'=>$os_array[0],
			'os_version'=>$os_array[1],
			'browser_name'=>$browser_array[0],
			'browser_version'=>$browser_array[1],
			'os'=>$os_array[0] . ' ' . $os_array[1],
			'browser'=>$browser_array[0] . ' ' . $browser_array[1],
			'agent_string'=>$agentstr,
			'results'=>$browser_array[0] . ' ' . $browser_array[1] . " on " . $os_array[0] . ' ' . $os_array[1]
		);
		
		return $ret;
	}
	
	private function browser_check($browser,$version,$agentstr) {
		$verbose = $this->verbose;
		
		if (preg_match("/(Galeon)\/([\d\.\-]+)/",$agentstr,$match)) {
			if ($verbose) { print "Matched BrowserCheck #1<br />\n"; }
			$browser = $match[1];
			$version = $match[2];
		}
		#Mozilla/5.0 (Windows; U; Win98; en-US; rv:0.9.4.1) Gecko/20020508 Netscape6/6.2.3
		elseif (preg_match("/(Netscape)6\/([\d\.\-]+)/",$agentstr,$match)) {
			if ($verbose) { print "Matched BrowserCheck #2<br />\n"; }
			$browser = $match[1];
			$version = $match[2];
		}
		elseif (preg_match("/(Nautilus)\/([\d\.]+)/",$agentstr,$match)) {
			if ($verbose) { print "Matched BrowserCheck #3<br />\n"; }
			$browser = $match[1];
			$version = $match[2];
		}
		elseif (preg_match("/(Opera)(\s+|\/)([\d\.]+)/i",$agentstr,$match2)) {
			if ($verbose) { print "Matched BrowserCheck #4<br />\n"; }
			$browser = $match2[1];
			$version = $match2[3];
		}
		elseif (preg_match("/(E?links)\s+\(([\d\.\-]+)/i",$agentstr,$match)) {
			if ($verbose) { print "Matched BrowserCheck #5<br />\n"; }
			$browser = $match[1];
			$version = $match[2];
		}
		elseif (preg_match("/(AOL)\s+([\d\.\-]+)/i",$agentstr,$match)) {
			if ($verbose) { print "Matched BrowserCheck #6<br />\n"; }
			$browser = $match[1];
			$version = $match[2];
		}
		elseif (preg_match("/(Konqueror)[\s+\/]([\d\.\-]+)/i",$agentstr,$match)) {
			if ($verbose) { print "Matched BrowserCheck #7<br />\n"; }
			$browser = $match[1];
			$version = $match[2];
		}
		elseif (preg_match("/(Safari)\/(\d+)/i",$agentstr,$match)) {
			if ($verbose) { print "Matched BrowserCheck #8<br />\n"; }
			$browser = $match[1];
			#$version = "v" . $match[2];
			$version = $match[2];
		} elseif (preg_match("/curl\/([\d\.]+)/i",$agentstr,$match)) {
			if ($verbose) { print "Matched BrowserCheck #9<br />\n"; }
			$browser = "Curl";
			$version = $match[1];
		}
		#Mozilla/5.0 (campatible; Konqueror/3.0.0-10; Linux)
		#elseif (preg_match("/^(.*?)\/([\d\.\-]+)/i",$agentstr,$match)) {
		#	$browser = $match[1];
		#	$version = $match[2];
		#}
	
		// If the browswer is Mozilla version 4 or less it's really Netscape
		if ( (substr($version,0,1) <= 4) && ($browser == "Mozilla") ) {
			if (!strstr(strtolower($agentstr),"gecko")) {
				$browser = "Netscape";
			}
		}
		
		$browser || $browser = "Unknown";
		$version || $version = "Unknown";
	
		return array($browser,$version);
	}
	
	public function os_check($os,$osversion,$agentstr) {
		global $browser,$bversion,$verbose;
	
		#print "|$os|";
	
		// If the os reports itself as NT 5.0 it's really Win2k
		if ( preg_match("/Windows NT/i",$os) && $osversion == 5) {
			if ($verbose) { print "Matched OSCheck #1<br />\n"; }
			$os = "Windows";
			$osversion = "2000";
		} elseif ( preg_match("/Windows NT/i",$os) && $osversion == 5.1) {
			if ($verbose) { print "Matched OSCheck #2<br />\n"; }
			$os = "Windows";
			$osversion = "XP";
		} elseif ( preg_match("/Windows NT/i",$os) && $osversion == 6.0) {
			if ($verbose) { print "Matched OSCheck #2<br />\n"; }
			$os = "Windows";
			$osversion = "Vista";
		} elseif ( $os == "Win" ) { 
			if ($verbose) { print "Matched OSCheck #3<br />\n"; }
			$os = "Windows"; 
		} elseif ( $os == "WinNT" ) {
			if ($verbose) { print "Matched OSCheck #4<br />\n"; }
			$os = "Windows";
			$osversion = "NT";
		} elseif ($browser == "AOL") {
			if ($verbose) { print "Matched OSCheck #5<br />\n"; }
			preg_match("/(Windows)\s+(.*?);/i",$agentstr,$match);
			$os = $match[1];
			$osversion = $match[2];
		} elseif ( preg_match("/PPC Mac OS X/i",$os)) {
			if ($verbose) { print "Matched OSCheck #6a<br />\n"; }
			$os = "Macintosh";
			$osversion = "OS X";
		} elseif (preg_match("/(Mac|Macintosh);.*?;(.*?)[\);]/",$agentstr,$match)) {
			if ($verbose) { print "Matched OSCheck #6b<br />\n"; }
			$os = $match[1];
	
			#Os version is NOT PPC
			$osversion = $match[2];
			#$osversion = "Unknown";
		}
		#IE for the mac, this is a weird one
		# Mozilla/4.0 (compatible; MSIE 5.14; Mac_PowerPC)
		elseif (strstr($agentstr,"Mac_PowerPC")) {
			if ($verbose) { print "Matched OSCheck #7<br />\n"; }
			$os = "Macintosh";
			$osversion = "PowerPC";
		} elseif ( preg_match("/(Linux)\s+([0-9a-zA-Z\.\-]+)/i",$agentstr,$match)) {
			if ($verbose) { print "Matched OSCheck #8<br />\n"; }
			$os = $match[1];
			$osversion = $match[2];
	
			#if (strstr($osversion,"686") || strstr($osversion,"386") ) {
			#	$osversion = "Unknown";
			#}
		} elseif ( preg_match("/Windows NT/i",$os) && $osversion == 5.2) {
			if ($verbose) { print "Matched OSCheck #9<br />\n"; }
			$os = "Windows";
			$osversion = "2003";
		// FreeBSD check
		} elseif ( preg_match("/FreeBSD\s+(.+?);/i",$agentstr,$match)) {
			if ($verbose) { print "Matched OSCheck #10<br />\n"; }
			$os = "FreeBSD";
			$osversion = $match[1];
		} elseif ( preg_match("/(i\d{3}).*(linux)/i",$agentstr,$match)) {
			if ($verbose) { print "Matched OSCheck #10<br />\n"; }
			$os = "Linux";
			$osversion = $match[1];
		}
	
		#print "|$os|";
	
		if (!$os) {
			if (strstr($agentstr,"Windows 98")) { 
				$os = "Windows";
				$osversion = "98";
			}
			elseif (strstr($agentstr,"Unix")) {
				$os = "Unix";
			}
			else {
				$os = "Unknown";
			}
		}
	
		$osversion || $osversion = "Unknown";
	
		return array($os,$osversion);
	}	
	
	function write_log($agent_string,$os,$os_ver,$browser,$b_ver) {
		if (!$this->write_log_file) { return 0; }
		
		$gstr = "OS: '$os' Ver: '$os_ver' -- Browser: '$browser' Ver: '$b_ver'\n";
		$as = $agent_string . "\n";
		$filename = "/tmp/gcount_agent_string.txt";
	
		$fp = fopen($filename,"a");
		fwrite($fp,$as . $gstr . "\n");
		fclose($fp);
	}

}

?>
