#!/usr/bin/perl

use strict;
use DBI; 
use Cwd;

my $out_dir = "/tmp/build";
my $version = $ARGV[0];

#################################################################

if (!$version) { die(usage()); }
my $start_dir = getcwd;

my $build_dir = "$out_dir/gcount";

if (-d $build_dir) {
	die("Work directory '$build_dir' exists, error!\n");
}

system("mkdir -p $build_dir");

my $filename = "gcount-pre-$version.tar.gz";
my $cmd = "tar cfvpz $filename gcount/ > /dev/null";
print "# Creating pre-modded backup of GCount -> $filename\n";

my $cmd = "perl -pi -e \"s/^GCount Version: (.*)\$/GCount Version: $version/ig\" INSTALL";
system($cmd);
print "# Updated the version in the INSTALL file\n";


$cmd = "perl -pi -e \"s/Current Version: (.*?)\</Current Version: $version\</ig\" index.html";
system($cmd);
print "# Updated the version in the index.html file\n";

my $clean_date = clean_date();
$cmd = "perl -pi -e \"s/Last Updated: .*\$/Last Updated: $clean_date/ig\" INSTALL";
system($cmd);
print "# Updated the \"last updated\" in the INSTALL file\n";


##########################################################################

my $cmd = "rsync -avPq --exclude='*.zip' --exclude='*.gz' --exclude='*.bz2' . $build_dir";
system($cmd);

my $cmd = "perl -pi -e \"s/Rewrite/#Rewrite/ig\" $build_dir/.htaccess";
system($cmd);
print "# Turned off mod_rewrite in .htaccess\n";


$cmd = "perl -pi -e \"s/ignore_ip_list = array\.\*/ignore_ip_list = array('54.2.1.234.17','1.2.3.4');/ig\" $build_dir/gcount.class.php";
system($cmd);
print "# Reset the ip_ignore_list in gcount.class.php\n";

#### UNSET ADMIN UN/PWD ###
$cmd = "perl -pi -e \"s/admin_username =.*/admin_username = \\\"\\\";/ig\" $build_dir/gcount.class.php";
system($cmd);
print "# Reset the admin username\n";

$cmd = "perl -pi -e \"s/admin_password =.*/admin_password = \\\"\\\";/ig\" $build_dir/gcount.class.php";
system($cmd);
print "# Reset the admin password\n";

chdir($out_dir);
#my $dbh = DBI->connect("dbi:SQLite2:dbname=$build_dir/gcount-data.bin","","");
print "# Resetting DB\n";
#$dbh->do("DELETE FROM Counter;");
#$dbh->do("DELETE FROM CounterLog;");
#$dbh->do("VACUUM;");

$cmd = "cat $out_dir/gcount/sqlite.sql | sqlite3 $out_dir/gcount/database/gcount-data.bin";
#print $cmd;
system($cmd);

my $filename = "$out_dir/gcount-$version.tar.gz";
my $cmd = "tar --exclude .svn -cvpzf $filename gcount/ > /dev/null";
system($cmd);
print "# Created $filename\n";
my $dis .= "cp $filename .\n";
$dis .= "rm gcount-current.tar.gz\n";
$dis .= "ln $filename gcount-current.tar.gz -s\n";

my $filename = "$out_dir/gcount-$version.tar.bz2";
my $cmd = "tar --exclude .svn -cvpjf $filename gcount/ > /dev/null";
system($cmd);
print "# Created $filename\n";
$dis .= "cp $filename .\n";
$dis .= "rm gcount-current.tar.bz2\n";
$dis .= "ln $filename gcount-current.tar.bz2 -s\n";

my $filename = "$out_dir/gcount-$version.zip";
my $cmd = "zip -9qr $filename gcount/ -x \"*.svn*\"";
system($cmd);
print "# Created $filename\n";
$dis .= "cp $filename .\n";
$dis .= "rm gcount-current.zip\n";
$dis .= "ln $filename gcount-current.zip -s\n";

print "\n# Release commands:\n";
print $dis;

sub usage() {
	return "$0 [version]\n";
}

chdir($start_dir);

sub clean_date() {
	my $epoch = shift();
	my $time = shift();

	my @date;
	if ($epoch) { @date = localtime($epoch); }
	else { @date = localtime(); }

	my $sql_date = ($date[5] + 1900) . "-" . ($date[4] + 1) . "-" . $date[3];
	if ($time) { $sql_date .= " " . $date[2] . ":" . $date[1] . ":" . $date[0]; }

	return $sql_date;
}
