<?PHP

class gcount {

	/////////////////////////////////////////////////////////////////////////////////////
	// CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE //
	/////////////////////////////////////////////////////////////////////////////////////
	public $admin_username = "";
	public $admin_password = "";
	public $db_path = "./database/gcount-data.bin"; // Path the SQLite database
	public $counter_path = "./counters/"; // Path the image strips used in the counters
	public $default_name = "default"; // "Name" to use if no name is no name is sent
	public $default_digits = 5; // Default digits to show
	public $default_typeface = 3; // Default type face to use
	public $fqdn_log = 1; // Log the DNS name to the database, not just the IP
	public $ignore_ip_list = array('54.2.1.234.17','1.2.3.4');

	// Uncomment the following lines to configure and use mysql as your database
	// engine. Requires PHP to be compiled with PDO support, and the PDO MySQL driver
	/*
	public $mysql_host = "localhost";
	public $mysql_db = "test";
	public $mysql_user = "gcount";
	public $mysql_pass = "gcount";
	*/
	/////////////////////////////////////////////////////////////////////////////////////
	// CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE //
	/////////////////////////////////////////////////////////////////////////////////////

	public $report_limit = 30;

	public function __construct() {
		/////////////////////////////////////////////////////////////////////////////////////
		// CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE //
		/////////////////////////////////////////////////////////////////////////////////////
		$this->options['session_limit'] = 300;
		/////////////////////////////////////////////////////////////////////////////////////
		// CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE CHANGABLE //
		/////////////////////////////////////////////////////////////////////////////////////
	
		//////////////////////////////////////////////////////////////////////////////////////
		// Do *not* change anything under this line unless you know what you're doing!      //
		//////////////////////////////////////////////////////////////////////////////////////

		require('db_query.class.php');
		$dsn = "sqlite:" . $this->db_path;

		$this->db = new db_query($dsn);

		$this->get_options();
		$this->debug_log[] = $this->get_config_debug();
	}

	public function get_counter() {
		$this->benchmark('start');
		
		// If GD is not compiled in!
		if (!function_exists("ImageCreate")) {
			$error_img = "images/logo.png";
			$this->send_image($error_img);

			exit;
		} 

		$db_path = $this->db_path;

		$this->start_time = $this->get_microtime();

		if ($this->options['debug']) { $this->debug_log[] = "GCount started at " . date("Y-m-d H:i:s"); }
		if ($this->options['debug']) { $this->debug_log[] = "Opening database <b>'$db_path'</b>"; }
		
		$name = $this->options['name'];
		$action = $this->action;

		if ($action == "typefaces") {
			$this->html($this->show_all_typefaces());
		} elseif ($action == "report") {
			$this->html($this->show_report($name));
		} elseif ($action == "summary") {
			$this->html($this->show_summary($name));
		} elseif ($action == "phpinfo") {
			phpinfo();
			exit;
		} elseif ($action == "admin") {
			$this->html($this->show_admin());
		} else {
			$this->get_counter_image();
		}

		return 1;
	}

	private function error($msg) {
		$width = 500;
		$height = 20;

		// If we're in debug mode (text mode) print out the message
		if ($this->options['debug']) { print "$msg"; exit; }

		if (is_numeric($msg)) {
			$msg = "#$msg";
		}
	
		// Create a blank image 150 x 30
		$new_img = ImageCreate($width,$height);
		// Colors for background, and text
		$bg_color = ImageColorAllocate($new_img,255,255,255);
		$text_color = ImageColorAllocate($new_img,0,0,0);
    
		// File the whole thing with a black rectangle
		ImageFilledRectangle($new_img,0,0,$width,$height,$bg_color);

		// Add a border around the box
		ImageRectangle($new_img,0,0,$width - 1,$height - 1,$text_color);

		// Put this text over the top of it
		ImageString($new_img,1,5,5,"Error: $msg",$text_color);
    
		$this->send_image($new_img);

		// die so we don't continue executing any PHP and mess up the image
		die;

	}

	public function get_counter_image() {
		$this->options['name'] || $this->options['name'] = $this->default_name;
		$this->options['typeface'] || $this->options['typeface'] = $this->default_typeface;
		$this->options['digits'] || $this->options['digits'] = $this->default_digits;

		if ($this->options['count']) { 
			$count = $this->options['count']; 
		}

		$this->benchmark('get_counter_image');

		$name = $this->options['name'];

		// If the count is not sent in via options, log it
		if (!$this->options['count']) {
			$this->log_hit($name);
			$this->benchmark('log_hit');
		}

		// Get the count and set it in the object
		$count || $count = $this->get_count($name);
		$this->benchmark('get_count');
		$this->count = $count;

		if ($this->options['debug']) { $this->debug_log[] = "Looking up count for: '$name' -> $count hits"; }

		// print "Name: $name Typeface: $typeface Digits: $digits Count: $count<br />\n";
		// die;

		$img = $this->counter_image($this->count,$this->options['digits'],$this->options['typeface']);
		$this->benchmark('counter_image');

		$this->end_time = $this->get_microtime();
		$total = round($this->end_time - $this->start_time,4);

		if ($this->options['debug']) {
			$PHP_SELF = $_SERVER['PHP_SELF'];
			require_once("agent.class.php");
			$ag = new agent();

			$this->debug_log[] = "Agent: " . $ag->agent_info['results'];
			$this->debug_log[] = $this->get_cpu_info();
			$this->debug_log[] = "Total time to process: " . $total . " seconds\n";

			$this->debug_log[] = "<b>PHP Information:</b> <a href=\"$PHP_SELF?show=phpinfo\">phpinfo()</a>\n";

			$this->debug_log[] = "<b>Benchmark:</b>";
			if ($this->options['debug']) {
				$this->debug_log[] = $this->benchmark('stop');
			}

			$this->debug_log[] = "\n" . $this->get_database_fields();

			$this->debug_log[] = "\n<a href=\"$PHP_SELF?name=$name&show=report\">Report</a> | <a href=\"$PHP_SELF?name=$name&show=summary\">Summary</a>";
		
			$output = join("\n",$this->debug_log);
			$output = "<pre>$output</pre>";

			$output .= $this->db->summary();

			$this->html($output);
		}
	}
	
	public function get_count($count_name) {
		$cnt_id = $this->get_cnt_id($count_name);
		$sql = "SELECT COUNT(*) AS Count FROM CounterLog l WHERE CntID = $cnt_id;";

		if ($this->options['debug']) {
			$this->debug_log[] = "Counter <b>'$count_name'</b> is CntID: $cnt_id";
		}

		//print $sql;
		$data = $this->db->query($sql,'one_data');
		$ret = intval($data);

		return $ret;
	}

	private function num_typefaces() {
		$dir = $this->counter_path;

		$glob = glob("$dir/counter*.png");

		$ret = sizeof($glob);

		if ($this->options['debug']) { $this->debug_log[] = "Checking <b>'$dir'</b> for counter image strips. Found $ret counter image strips"; }

		if ($ret <= 0) {
			$this->error('No typefaces installed? (Error #189)');
		}

		return $ret;
	}

	private function counter_image($count,$digits = 5,$typeface = 3) {
		srand ((double) microtime() * 1000000);
		$num_typefaces_installed = $this->num_typefaces();
		$max_length = 10;

		// Check the typeface for random
		if ($typeface == -1) {
			$typeface = rand(1,$num_typefaces_installed);
		}
		// make sure that it's beween our valid typeface specs 
		else if ( ($typeface < 1) || ($typeface > $num_typefaces_installed) ) {
			// default typeface
			$typeface = 5;
		}
	
		#die("|$typeface|");
	    
		// Could be used for a random counter
		if ($count == -1) {
			$count = rand(1,9999);
		}

		$len = strlen($count);

		if ( $len > $max_length ) {
			$this->fail(45);
		}
	    
		// Make sure the digits and the number are ok together
		if ($len > $digits) {
			$digits = $len;
		}
		elseif ($digits > $max_length) {
			$digits = $max_length;
		}

		//print "'$len' '$digits' '$max_length'";
		if ($this->options['debug']) { $this->debug_log[] = "Length: $len MaxLength: $max_length Digits: $digits"; }
		
		// If there are more digits then the number, pad it with 0s
		if ($len < $digits) {
			// Get the difference (the number of 0s to pad it with)
			$zeropad = $digits - $len;
			$count = str_repeat('0',$zeropad) . $count;
		}

		// Create the path to the image and open it for manipulation later
		$image_path = $this->counter_path . "counter" . $typeface . ".png"; 
		if (!is_readable($image_path)) {
			$this->error("Can't read $image_path (Error: #891)");
		}

		if ($this->options['debug']) { $this->debug_log[] = "Image path to use to get source images: <b>'$image_path'</b>"; }
		#print "$image_path";
	    
		// Load the counter images to a temp img for later use
		$src_image = ImageCreateFromPNG($image_path);
		if (!$src_image) { $rats->text_error("<b>NOTE:</b> It looks like you may not have GD support compiled into PHP (Error #285)") ; }
	
		// Width in x and height in y
		$src_width = ImageSX($src_image);
		$src_height = ImageSY($src_image);
		
		// Width of one digit
		$char_width = $src_width / 10;
		// Width the total new image is going to be
		$new_width = $char_width * $digits;
		
		// Create the new (empty) image with given proportions
		$new_image = ImageCreate($new_width,$src_height) or $this->fail(20);

		// Loop through for each digit.  Each digit getting assigned $digit and 
		// being processed accordingly
		for ($i = 0;$i < $digits;$i++) {
			#print "$i";

			#print "Digits: $digits Count: $count";
			$digit = substr($count,$i,1);

			#print "Digit: $digit<br />";
	
			// The X value of where to copy the original char from
			$source_x = $digit * $char_width;
			// Should always be zero because we're only dealing with two dimensional
			// number strips
			$source_y = 0;
			
			// The X value of the destination character
			$dest_x = $i * $char_width;
			$dest_y = 0;
			
			//int ImageCopy (int dst_im, int src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h)
			ImageCopy($new_image,$src_image,$dest_x,$dest_y,$source_x,$source_y,$char_width,$src_height) or $this->fail(30);
			#print "$new_image,$src_image,$dest_x,$dest_y,$source_x,$source_y,$char_width,$height";
		}
	
		// free the memory used by the image
		ImageDestroy($src_image);

		return($this->send_image($new_image));
	}

	private function send_image($img) {
		if ($this->options['debug']) { return ""; }

		if (!$img) {
			print "Something went wrong trying to send the image to the browser";
			die;
		}
	
		// We use an expired header so that the image will not be cached
		Header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");  
		Header("Content-type: image/png");

		if (is_readable($img)) {
			readfile($img);
		} else {
			ImagePNG($img);
			ImageDestroy($img);
		} 

		return 1;
	}

	private function log_hit($name) {
		// If the counter has no hits create the counter!
		if ($this->count == 0) { 
			$this->create_counter($name);
		}
		
		if ($this->ignore_hit()) {
			return 0; 
		}

		$this->log_hit_agent($name);

		//$this->debug = $sql;
	}

	private function log_hit_agent($name) {
		#################################################################################
		## The HIT has to be logged for the session checking to work. It checks the 
		## CounterLog table to see if there has been a hit in the last XXX seconds.
		## If so it ignores it. So this is mandatory to check sessions
		#################################################################################
	
		#$this->debug = 'log_hit_agent';
		require('agent.class.php');

		if ($this->options['debug']) { $this->debug_log[] = "Logging the agent"; }

		$this->agent = new agent;
		$browser_name = $this->agent->agent_info['browser_name'];
		$browser_version = $this->agent->agent_info['browser_version'];
		$os_name = $this->agent->agent_info['os_name'];
		$os_version = $this->agent->agent_info['os_version'];
		$refer = $this->db->quote($_SERVER['HTTP_HOST']);
		$host = $_SERVER['REMOTE_ADDR'];

		if ($this->fqdn_log) {
			$fqdn = gethostbyaddr($host);
			if ($this->options['debug']) { $this->debug_log[] = "Converting $host into $fqdn"; }
			$host = $fqdn;
		}

		$host = $this->db->quote($host);

		$cnt_id = $this->get_cnt_id($name);
		if (!isset($cnt_id)) { $this->error("Cannot get CntID! (Error #183)"); }

		if ($this->options['debug']) { $this->debug_log[] = "Name: $name -> CntID: $cnt_id"; }
		if ($this->options['debug']) { $this->debug_log[] = "Remote IP: $host Refer: $refer"; }

		//$time_stamp = date("Y-m-d H:i:s");
		$time_stamp = time();

		if ($this->options['debug']) { $this->debug_log[] = "Browser: $browser_name Version: $browser_version"; }
		if ($this->options['debug']) { $this->debug_log[] = "OS: $os_name Version: $os_version"; }
		
		$sql = "INSERT INTO CounterLog (CntID,LogBrowser,LogBrowserVersion,LogOs,LogOsVersion,LogTimeStamp,LogHost,LogRefer) VALUES ($cnt_id,'$browser_name','$browser_version','$os_name','$os_version','$time_stamp',$host,$refer);";

		// print $sql;

		$ret = $this->db->query($sql);

		return $ret;
	}

	private function get_cnt_id($name) {
		if (!$name) { return 0; }
	
		$sql = "SELECT CntID FROM Counter WHERE CntName = '$name';";
		//print "$sql<br />";

		$data = $this->db->query($sql,'one_data');
		$ret = intval($data);

		return $ret;
	}

	private function ignore_hit() {
		#$sl = $this->options['session_limit'];
		#if ($this->options['debug']) { $this->debug_log[] = "IGNORE FUNCTION $sl"; }

		if (isset($this->global_ignore) && $this->global_ignore == 0) {
			// DO NOT IGNORE, it's forced
		} elseif (!$this->options['session_limit']) {
			if ($this->options['debug']) { $this->debug_log[] = "<b>ignore_hit</b> has <span class=\"red\"><b>no session limit</b></span>, not ignoring anything (CRAZY MODE!)"; }

			return 0;
		} elseif ($this->ignore_ip_list) {

			$ignore_text = join(", ",$this->ignore_ip_list);
			if ($this->options['debug'] && $ignore_text) { $this->debug_log[] = "Ignoring IPs: $ignore_text"; }

			foreach ($this->ignore_ip_list as $ip) {
				$remote_ip = $_SERVER['REMOTE_ADDR'];
				
				if (preg_match("/$ip/",$remote_ip)) {
					if ($this->options['debug']) { $this->debug_log[] = "<span style=\"color: red; font-weight: bold;\">Ignored:</span> hit because it's from an ignored IP <b>$ip</b>"; }
					return 1;
				}
			}
		// It's not ignored globally, and there is NO ignore list at all
		} else {
		}
	
		$method = "database";		
		
		// Not implemented at this time, not sure if I want to use this method or not!
		if ($method == 'cookie') {
		// If the session limit is zero don't even both checking
		} elseif ($this->options['session_limit'] === 0) {
			if ($this->options['debug']) { 
				// No need to log here, we log above if the time is zero
				//$this->debug_log[] = "Session time is zero, not ignoring hit!"; 
			}
		// Check the database for hits in the last X seconds
		} elseif ($method == 'database') {
			if ($this->options['debug']) { $this->debug_log[] = "<b>ignore_hit</b> is using the 'database' method"; }
			
			$time = time() - $this->options['session_limit'];
			#$date = date('Y-m-d H:i:s',$time);
			#$diff = $time - 1092793068;
			$name = $this->options['name'];

			#####################################################################
			## For this to work log_agent_hit has to be on, because it logs the
			## hit to the DB. It that's not on this will ALWAYS return 0, and 
			## thus everything we count as a hit regarless of session limit!
			#####################################################################

			$host = $_SERVER['REMOTE_ADDR'];
			if ($this->fqdn_log) {
				$host = gethostbyaddr($host);
			}
			$host = $this->db->quote($host);

			$sql = "SELECT LogID, LogTimeStamp FROM CounterLog l, Counter c WHERE c.CntID = l.CntID AND LogTimeStamp > $time AND CntName = '$name' AND LogHost = $host ORDER BY LogTimeStamp DESC LIMIT 1;";

			// print $sql;

			$sl = $this->options['session_limit'];
			if ($this->options['debug']) { $this->debug_log[] = "Checking the database for hits in the last <b>$sl</b> seconds"; }

			$data = $this->db->query($sql);

			$log_id = intval($data[0]['LogID']);
			$db_date = date("Y-m-d H:i:s",$data[0]['LogTimeStamp']);
			$session_limit = $this->options['session_limit'];

			if ($this->options['debug'] && $log_id) { 
				$this->debug_log[] = "<span style=\"color: red; font-weight: bold;\">Ignored:</span> LogID #$log_id -> '$db_date' has a timestamp in the range ($session_limit seconds)"; 
			} elseif ($this->options['debug']) {
				$this->debug_log[] = "<span style=\"color: green; font-weight: bold;\" >Passed:</span> hit was <b>not</b> ignored";
			}
		}
	
		#$this->debug_log[] = "ID: $log_id";
		return $log_id;
	}

	public function get_microtime(){ 
		//print_r(microtime());
		list($usec, $sec) = split(" ",microtime());
		return ((float)$usec + (float)$sec);
	}

	private function create_counter($name) {
		if (!$name) { return 0; }

		$sql = "SELECT CntID FROM Counter WHERE CntName = '$name';";
		$data = $this->db->query($sql,'one_data');

		if ($data) { return $data; }

		$name = $this->db->quote($name);
		$sql = "INSERT INTO Counter (CntName) VALUES ($name);";
		#print "$sql<br />";

		$this->count = 1;

		if ($this->options['debug']) { $this->debug_log[] = "Creating counter for <b>'$name'</b>"; }

		if (!$c_id = $this->db->query($sql)) {
			$this->error("Couldn't insert into 'Counter' (Error: #528)");
		}

		$this->global_ignore = 0;

		return $c_id;
	}

	private function get_database_fields() {
		$tables = array('Counter','CounterLog');

		$ret .= "Database table layout:";
	
		foreach ($tables as $name) {
			$sql = "SELECT * FROM $name LIMIT 1;";

			// Get the field names for each table
			$data = $this->db->query($sql);
			foreach (array_keys($data) as $key) {
				$out[] = $key;
			}

			$ret .= "\n<b>$name</b>: ";
			$ret .= join(", ",$out);
			unset($out);
		}

		return $ret;
	}

	public function show_all_typefaces() {
		$dir = $this->counter_path;

		$glob = glob("$dir/counter*.png");

		foreach ($glob as $file) {
			preg_match("/counter(\d+)\.(\w{3})/",$file,$match);
			if ($match[1]) { 
				$num = $match[1];
				$list[$num] = $file;
			}

		}

		ksort($list);

		$out .= "<table>\n";
		foreach (array_keys($list) as $num) {
			$name = $list[$num];
		
			$out .= "<tr>\n";
			$out .= "\t<td>#$num</td>\n";
			$out .= "\t<td><img src=\"$name\" alt=\"\" /></td>\n";
			$out .= "</tr>\n";

		}
		$out .= "</table>\n";

		return $out;
	}

	public function show_report($name,$offset = 0) {
		if (!$name) { $this->text_error("No name specified"); }
		$limit = $this->report_limit;

		$offset || $offset = intval($_GET['offset']);
	
		$data = $this->get_report_data($name,$offset,$limit);
		$hits = $this->get_count($name);

		if (!$data) {
			$this->text_error("There is no counter with the name '$name'");
		}

		$out .= "<span class=\"header\">Counter information for: <b>$name</b> ($hits total hits)</span>\n";
		$out .= "<br />\n";
		$out .= "<table>\n";

		$out .= "<tr class=\"th\">\n";
		$out .= "\t<td>TimeStamp</td>\n";
		$out .= "\t<td>Browser</td>\n";
		$out .= "\t<td>OS</td>\n";
		$out .= "\t<td>Remote</td>\n";
		//$out .= "\t<td>Page</td>\n";
		$out .= "</tr>\n";

		foreach (array_keys($data) as $log_id) {
			$host = $data[$log_id]['LogHost'];
			$refer = $data[$log_id]['LogRefer'];
			$browser = $data[$log_id]['LogBrowser'];
			$browser_v = $data[$log_id]['LogBrowserVersion'];
			$os = $data[$log_id]['LogOS'];
			$os_v = $data[$log_id]['LogOSVersion'];
			
			#$timestamp = $data[$log_id]['LogTimeStamp'];
			$timestamp = date("Y-m-d h:i:sa",$data[$log_id]['LogTimeStamp']);
			
			#$timestamp = date("r",$timestamp);

			$out .= "<tr>\n";
			$out .= "\t<td>$timestamp</td>\n";
			$out .= "\t<td>$browser $browser_v</td>\n";
			$out .= "\t<td>$os $os_v</td>\n";
			$out .= "\t<td>$host</td>\n";
			//$out .= "\t<td><a href=\"http://$refer\">$refer</a></td>\n";
			$out .= "</tr>\n";
		}
		$out .= "</table>\n";

		$prev_offset = $offset - $limit;
		$next_offset = $offset + $limit;
		
		if ($prev_offset < 0) { $prev_link = "Prev"; }
		else { $prev_link = "<a href=\"$PHP_SELF?show=report&name=$name&offset=$prev_offset\">Prev</a>"; }

		if ($next_offset >= $hits) { $next_link = "Next"; }
		else { $next_link = "<a href=\"$PHP_SELF?show=report&name=$name&offset=$next_offset\">Next</a>"; }

		$report_link = "<a href=\"$PHP_SELF?show=summary&name=$name\">Summary</a>";
		$admin_link = "<a href=\"$PHP_SELF?show=admin\">Admin</a>";
		
		$out .= "<span class=\"normal_text\">$prev_link | $next_link | $report_link | $admin_link</span>\n";
		
		$ret = $out;

		return $ret;
	}

	private function get_report_data($name,$offset,$limit) {
		if (!$name) { return 0; }
		$offset = intval($offset);
		$limit = intval($limit);

		if (!isset($offset) || !isset($limit)) { return 0; }

		$sql = "SELECT LogHost, LogRefer, LogBrowser, LogBrowserVersion, LogOS, LogOSVersion, LogTimeStamp, LogID FROM CounterLog l, Counter c WHERE c.CntID = l.CntID AND CntName = '$name' ORDER BY LogTimeStamp DESC LIMIT $offset,$limit;";

		$data = $this->db->query($sql);
		foreach ($data as $item) {
			$log_id = $item['LogID'];
			$ret[$log_id] = $item;
		}

		return $ret;
	}

	public function show_admin() {
		$action = $_REQUEST['action'];
		$cnt_id = $_REQUEST['cnt_id'];

		$PHP_SELF = $_SERVER['PHP_SELF'];
		
		// Start the session
		session_start();

		$session_un = $_POST['username'];
		$session_pwd = $_POST['password'];

		//print "Form: '$session_un' '$session_pwd'<br />\n";

		$session_un || $session_un = $_SESSION['username'];
		$session_pwd || $session_pwd = $_SESSION['password'];

		//print "Session: '$session_un' '$session_pwd'<br />\n";

		if (!$this->valid_admin_login($session_un,$session_pwd)) {
			$this->show_admin_login();
		}

		$_SESSION['username'] = $session_un;
		$_SESSION['password'] = $session_pwd;

		$names = $this->get_all_counter();

		if (!$names) {
			$this->html("There are no counters currently defined");
		} 

		// We get all this info twice because it may change after the
		// delete/reset!
		$ids = array_keys($names);
		$name = $names[$cnt_id]['name'];

		#print_r($_POST);
		#die;

		if (strtolower($action) == 'reset' && $name) { 
			if ($this->reset_counter($cnt_id)) {
				$msg = "Counter '<b>$name</b>' (#$cnt_id) reset!";
			} else {
				$msg = "Counter '<b>$name</b>' (#$cnt_id) did not reset!";
			}
		} elseif (strtolower($action) == 'delete' && $name) {
			if ($this->delete_counter($cnt_id)) {
				$msg = "Counter '<b>$name</b>' (#$cnt_id) has been deleted!";
			} else {
				$msg = "Counter '<b>$name</b>' (#$cnt_id) did not delete!";
			}
		} elseif (strtolower($action) == 'logout') {
			$_SESSION['username'] = "";
			$_SESSION['password'] = "";
			header("Location: $PHP_SELF?show=admin");
		}

		$sort_field = $_GET['sort'];
		$counter_info = $this->get_all_counter($sort_field);
		$total = $this->get_log_count();

		if ($this->options['is_sqlite']) {
			// Add 1 to make sure we never divide by zero
			$filesize = filesize($this->db_path) + 1;
			$filesize_text = round($filesize/1024, 3);

			if ($total) { $record_size = $filesize / $total; } 
			else { $record_size = 0; }
		}

		#print "Total: $total Size: $filesize Each record is $record_size kilobytes<br />";

		if ($msg) { 
			$out .= "<span class=\"header\">$msg</span>\n";
			$out .= "<br />\n";
			$out .= "<br />\n";
		}

		$database_name = basename($this->db_path);

		if (substr($sort_field,0,1) == "-") { $neg = ""; }
		else { $neg = "-"; }

		$sc .= "\tfunction confirm_delete(name,cnt_id) {\n";
		$sc .= "\t\tvar eid = document.getElementById('cnt_id');\n";
		$sc .= "\t\teid.value = cnt_id;\n";
		$sc .= "\t\treturn confirm('Completely delete the counter ' + name + '? #' + cnt_id);\n";
		$sc .= "\t}\n\n";

		$sc .= "\tfunction confirm_reset(name,cnt_id) {\n";
		$sc .= "\t\tvar eid = document.getElementById('cnt_id');\n";
		$sc .= "\t\teid.value = cnt_id;\n";
		$sc .= "\t\treturn confirm('Reset the counter ' + name + '? #' + cnt_id);\n";
		$sc .= "\t}\n";

		$this->script = $sc;
	
		if ($filesize_text) {
			$out .= "<span class=\"header\"><b>$database_name</b> size: $filesize_text Kbytes</span>\n\n";
		}

		$out .= "<form method=\"post\" action=\"$PHP_SELF?show=admin\">\n";
		$out .= "<input type=\"hidden\" name=\"cnt_id\" value=\"\" id=\"cnt_id\">\n";
		$out .= "<table>\n";
		$out .= "<tr class=\"th\">\n";
		$out .= "\t<td>ID #</td>\n";
		$out .= "\t<td><a href=\"$PHP_SELF?sort={$neg}name&show=admin\">Counter Name</a></td>\n";
		$out .= "\t<td><a href=\"$PHP_SELF?sort={$neg}hit&show=admin\">Last Hit</a></td>\n";
		$out .= "\t<td>Show</td>\n";
		$out .= "\t<td><a href=\"$PHP_SELF?sort={$neg}count&show=admin\">Records</a></td>\n";
		$out .= "\t<td>~ Size on Disk</td>\n";
		$out .= "\t<td>Actions</td>\n";
		$out .= "</tr>\n";

		foreach (array_keys($counter_info) as $cnt_id) {
			$name = $counter_info[$cnt_id]['name'];
			$count = $counter_info[$cnt_id]['count'];
			$size = round(($record_size * $count) / 1024,2);
			$PHP_SELF = $_SERVER['PHP_SELF'];
			$last_hit_date = date("Y-m-d h:i:sa",$counter_info[$cnt_id]['last_hit']);

			$total_hits += $count;

			$del_button = "<input type=\"submit\" name=\"action\" value=\"Delete\" class=\"small_button\" style=\"background: #a62e2e\" onclick=\"javascript: return confirm_delete('$name',$cnt_id)\" />";
			$reset_button = "<input type=\"submit\" name=\"action\" value=\"Reset\" class=\"small_button\" style=\"background: #44b741\" onclick=\"javascript: return confirm_reset('$name',$cnt_id)\"/>";
			//$hidden = "<input type=\"hidden\" name=\"cnt_id\" value=\"$cnt_id\" />";

			$out .= "<tr>\n";
			$out .= "\t<td>$cnt_id</td>\n";
			#$out .= "\t<td>#$cnt_id <a href=\"$PHP_SELF?name=$name&typeface=3\">$name</a></td>\n";
			$out .= "\t<td><a href=\"$PHP_SELF?name=$name&typeface=3\">$name</a></td>\n";
			$out .= "\t<td>$last_hit_date</td>\n";
			$out .= "\t<td><a href=\"$PHP_SELF?name=$name&show=report\">Report</a> / <a href=\"$PHP_SELF?name=$name&show=summary\">Summary</a></td>\n";
			$out .= "\t<td>$count</td>\n";
			$out .= "\t<td>$size Kbytes</td>\n";
			$out .= "\t<td>";
			#$out .= "<a href=\"$PHP_SELF?show=admin&action=reset&cnt_id=$cnt_id\" onclick=\"javascript: return confirm('Really reset $name to zero?')\">Reset</a>\n"; 
			#$out .= "<a href=\"$PHP_SELF?show=admin&action=delete&cnt_id=$cnt_id\" onclick=\"javascript: return confirm('Completely delete $name?')\">Delete</a>\n";

			#$out .= "\n\t\t<form method=\"post\" action=\"$PHP_SELF?show=admin\">\n";
			$out .= "\t\t\t" . $del_button . " ";
			$out .= $reset_button;
			$out .= $hidden;
			#$out .= "\n\t\t</form>\n";
			$out .= "\t</td>\n";

			$out .= "</tr>\n";
		}
		$out .= "<tr><td colspan=\"7\" class=\"table_footer\">$total_hits hits total</td></tr>";
		$out .= "</table>\n";
		$out .= "<span class=\"logout\"><a href=\"$PHP_SELF?action=logout&show=admin\">Logout</a></span>";
		$out .= "</form>\n";

		return $out;
	}

	private function get_all_counter($sort = "") {
		if (!$sort) { $sort = "-hit"; }
	
		if ($sort == "name") { $sort = "CntName ASC"; }
		elseif ($sort == "count") { $sort = "COUNT ASC"; }
		elseif ($sort == "hit") { $sort = "LastHit ASC"; }
		elseif ($sort == "-name") { $sort = "CntName DESC"; }
		elseif ($sort == "-count") { $sort = "COUNT DESC"; }
		elseif ($sort == "-hit") { $sort = "LastHit DESC"; }
	
		#$sql = "SELECT Distinct(CntName) AS CntName, CntID FROM Counter ORDER BY CntName;";
		$sql = "SELECT Distinct(CntName) AS CntName, c.CntID AS CntID, COUNT(LogHost) AS Count, MAX(LogTimeStamp) AS LastHit FROM Counter c LEFT JOIN CounterLog l ON c.CntID = l.CntID WHERE c.CntID = l.CntID GROUP BY CntName ORDER BY $sort;";

		$info = $this->db->query($sql);

		foreach ($info as $data) {
			$cnt_id = $data['CntID'];
			$cnt_name = $data['CntName'];
			$count = $data['Count'];
			$last = $data['LastHit'];
		
			$ret[$cnt_id] = array('name'=>$cnt_name,'count'=>$count,'last_hit'=>$last);
		}

		$ret || $ret = array();

		return $ret;
	}

	private function get_log_count($ids = "") {
	
		if ($ids) {
			$text = join(",",$ids);
			$sql = "SELECT CntID, COUNT(*) AS Count FROM CounterLog WHERE CntID IN ($text) GROUP BY CntID;";
		} else {
			$sql = "SELECT COUNT(LogHost) AS Count FROM CounterLog;";

			$data = $this->db->query($sql,'one_data');
			return $data;
		}

		$data = $this->db->query($sql);
		foreach ($data as $item) {
			$cnt_id = $item['CntID'];
			$count = intval($item['Count']);
		
			$ret[$cnt_id] = $count;
		}

		return $ret;
	}

	private function default_style() {
		#$out .= "<style type=\"text/css\">\n";
		$out .= "td { border: 1px solid black; padding-left: 4px; padding-right: 4px; font-size: 9pt; }\n";
		$out .= "table { border-collapse: collapse; border: 2px solid black; font-family: sans; margin-bottom: 0px; }\n";
		$out .= ".normal_text { font-family: sans; font-size: 9pt; }\n";
		$out .= ".header { font-size: 14pt; font-weight: normal; }\n";
		$out .= ".report_header { font-size: 16pt; font-weight: bold; }\n";
		$out .= ".report_box { border: 2px solid black; padding: 4px; width: 720px; background: #dfddff; }\n";
		$out .= ".th { font-weight: bold; text-align: center; background: #ffe6b0 }\n";
		$out .= ".little_text { font-size: 7pt; }\n";
		$out .= ".table_footer { font-size: 8pt; background: #ffe6b0; text-align: center; font-weight: bold; }\n";
		$out .= ".alert { font-size: 14pt; color: red; }\n";
		$out .= ".small_button { font-size: 7pt; border: 1px solid; width: 50px; font-weight: bold; margin: 0px; padding: 0px; }\n";
		$out .= ".logout {font-size:8pt; }\n";
		$out .= ".red { color: red; }\n";

		#$out .= "</style>\n\n";

		return $out;
	}

	private function reset_counter($cnt_id) {
		if (!$cnt_id) { return 0; }
	
		/////////////////////////////////////////////////////////////////
		$sql = "DELETE FROM CounterLog WHERE CntID = $cnt_id;";
		# print "$sql<br />";
		$ret = $this->db->query($sql);
		/////////////////////////////////////////////////////////////////
		//$sql = "UPDATE Counter SET CntCount = 0 WHERE CntID = $cnt_id;";
		//$rs = sqlite_query($this->cn,$sql);
		//$ret += sqlite_changes($this->cn);
		/////////////////////////////////////////////////////////////////
		
		return $ret;
	}

	private function delete_counter($cnt_id) {
		if (!$cnt_id) { return 0; }
	
		/////////////////////////////////////////////////////////////////
		$sql = "DELETE FROM CounterLog WHERE CntID = $cnt_id;";
		# print "$sql<br />";
		$ret += $this->db->query($sql);
		/////////////////////////////////////////////////////////////////
		$sql = "DELETE FROM Counter WHERE CntID = $cnt_id;";
		# print "$sql<br />";
		$ret += $this->db->query($sql);
		/////////////////////////////////////////////////////////////////

		return $ret;
	}

	private function vacuum() {
		$sql = "VACUUM;";

		$rs = sqlite_query($this->cn,$sql);

		return 1;
	}

	private function get_top_os($name) {
		$sql = "SELECT Distinct(LogOS) as LogOS, Count(*) AS Count FROM CounterLog l, Counter c WHERE c.CntID = l.CntID AND CntName = '$name' AND LogOS != \"\" GROUP BY LogOS ORDER BY Count DESC LIMIT 10;";

		$data = $this->db->query($sql);
		foreach ($data as $item) {
			$os = $item['LogOS'];
			$count = $item['Count'];
			
			$ret[$os] = $count;
		}

		return $ret;
	}

	private function get_top_browser($name) {
		$sql = "SELECT Distinct(LogBrowser) as LogBrowser, Count(*) AS Count FROM CounterLog l, Counter c WHERE l.CntID = c.CntID AND CntName = '$name' AND LogBrowser != \"\" GROUP BY LogBrowser ORDER BY Count DESC LIMIT 10;";

		$data = $this->db->query($sql);
		foreach ($data as $item) {
			$br = $item['LogBrowser'];
			$count = $item['Count'];
			
			$ret[$br] = $count;
		}

		return $ret;
	}

	public function show_summary($name) {
		$this->start_stopwatch();
		
		$br = $this->get_top_browser($name);
		$total = array_sum($br);
		$max_width = 700;
		$PHP_SELF = $_SERVER['PHP_SELF'];

		$out .= "<div class=\"normal_text\">\n";
		$out .= "<span class=\"report_header\">Statistics for counter $name - $total hits</span>";
		$out .= "<br />\n";
		$out .= "<br />\n";

		$out .= "<span class=\"report_header\">Browser Stats</span><br />\n";
		$out .= "<div class=\"report_box\">\n";
		foreach (array_keys($br) as $browser) {
			$count = $br[$browser];

			if ($browser == "Mozilla") { $browser .= " (Gecko)"; }

			$percent = $count / $total;
			$percent_text = round($percent * 100,1);
			$width = intval($max_width * $percent);

			$out .= "<b>$browser:</b> $count ($percent_text%)<br />\n";
			$out .= "<img src=\"images/bar-left.png\" alt=\"\" />";
			$out .= "<img src=\"images/bar-middle.png\" alt=\"\" width=\"$width\" height=\"18\" />";
			$out .= "<img src=\"images/bar-right.png\" alt=\"\" /><br />";

		}
		$out .= "</div>\n";

		$out .= "<br />\n";

		$os_info = $this->get_top_os($name);
		$total = array_sum($os_info);

		$out .= "<span class=\"report_header\">Operating System Stats</span><br />\n";
		$out .= "<div class=\"report_box\">\n";
		foreach (array_keys($os_info) as $os) {
			$count = $os_info[$os];

			$percent = $count / $total;
			$percent_text = round($percent * 100,1);
			$width = intval($max_width * $percent);

			$out .= "<b>$os:</b> $count ($percent_text%)<br />\n";
			$out .= "<img src=\"images/bar-left.png\" alt=\"\" />";
			$out .= "<img src=\"images/bar-middle.png\" alt=\"\" width=\"$width\" height=\"18\" />";
			$out .= "<img src=\"images/bar-right.png\" alt=\"\" /><br />";

		}
		$out .= "</div>\n";
		$out .= "<a href=\"$PHP_SELF?show=report&name=$name\">Back</a>\n";
		$out .= "</div>\n";

		$time = $this->stop_stopwatch();
		$out .= "\n<span class=\"little_text\">Rendered in $time seconds</span>";


		return $out;
	}

	private function start_stopwatch() {
		$this->start_time = $this->get_microtime();
	}

	private function stop_stopwatch() {
		$this->stop_time = $this->get_microtime();
		return round($this->stop_time - $this->start_time,3);
	}

	private function show_admin_login() {
		$PHP_SELF = $_SERVER['PHP_SELF'];

		$out .= "<span class=\"header\">Please login to view the admin panel!</span>\n\n";
		$out .= "<form method=\"post\" action=\"$PHP_SELF?show=admin\">\n";
		$out .= "\t<input type=\"text\" name=\"username\" value=\"username\" /><br />\n";
		$out .= "\t<input type=\"password\" name=\"password\" value=\"password\" /><br />\n";
		$out .= "\t<input type=\"submit\" value=\"Login\" style=\"margin-top: 10px; \" />\n";
		$out .= "</form>\n";

		$this->html($out);
		
		die;
	}

	private function valid_admin_login($un,$pwd) {
		if (!$this->admin_username || !$this->admin_password) {
			$msg = "<span class=\"alert\">Admin Username/Password not set logins are disabled until this is corrected</span>";
			$this->text_error($msg);
		}	
		

		if (!$un && !$pwd) {
			return 0;
		} elseif ($un == $this->admin_username && $pwd == $this->admin_password) {
			return 1;
		} elseif ($un != $this->admin_username || $pwd != $this->admin_password) {
			print "Sorry that username/password is invalid!<br />\n<br />\n";
			return 0;
		} else {
			return 0;
		}
	}

	private function text_error($msg) {
		$out .= "<span class=\"alert\">$msg</span>";
		$this->html($out);

		exit;
	}

	private function get_options() {
		$this->set_option("session_limit",array("session_limit","sl"));
		$this->set_option("debug","debug");
		$this->set_option("digits",array("digits","di"));
		$this->set_option("count",array("count","co"));
		$this->set_option("typeface",array("typeface","tf"));
		$this->set_option("name",array("name"));

		$uri = $_SERVER['REQUEST_URI'];
		if (preg_match("/(admin.html|show=admin)$/",$uri)) { $this->action = "admin"; }
		elseif (preg_match("/(summary.html|show=summary)/",$uri)) { $this->action = "summary"; }
		elseif (preg_match("/(report.html|show=report)/",$uri)) { $this->action = "report"; }
		elseif (preg_match("/(typefaces.html|show=typefaces)/",$uri)) { $this->action = "typefaces"; }
		elseif (preg_match("/(phpinfo.html|show=phpinfo)/",$uri)) { $this->action = "phpinfo"; }
		else { $this->action = "counter"; }
	}

	private function set_option($config_option,$search) {
		$debug = 0;
		$uri = $_SERVER['REQUEST_URI'];


		// We're just checking to see if it's present (not a key->value)
		if (!is_array($search)) {
			if (preg_match("/$search=1(\&|$)/",$uri)) {
				$found = 1;
			} elseif (preg_match("/$search\//",$uri)) {
				$found = 1;
			}

			if ($found) {
				if ($debug) { print "$search -> $found<br >\n"; }
				$this->options[$config_option] = 1;
				$found = "";
			}
		// We're looking for key/value
		} else {
			foreach ($search as $item) {
				#if ($debug) { print "We're looking for $item<br />"; }
				
				if (preg_match("/$item=(.*?)(\&|$)/",$uri,$match)) {
					$found = $match[1];
				} elseif (preg_match("/$item\/(.+?)\//",$uri,$match)) {
					$found = $match[1];
				}
				
				if (isset($found)) {
					if ($debug) { print "$item -> $found<br >\n"; }
					$this->options[$config_option] = $found;
					unset($found);
				}
			}
		}
	}

	private function get_config_debug() {
		foreach (array_keys($this->options) as $option) {
			$value = $this->options[$option];
			$ret .= "Options: $option -> $value\n";
		}

		return $ret;
	}

	private function html($html) {
		$content = join("",file('xhtml-template.html'));
	
		$style = $this->default_style();
		$script = $this->script;
		$body = $html;

		$body = preg_replace("/&/","&amp;",$body);

		$content = preg_replace("/\{style\}/",$style,$content);
		$content = preg_replace("/\{script\}/",$script,$content);
		$content = preg_replace("/\{body\}/",$body,$content);

		print $content;

		die;
	}

	private function get_cpu_info() {
		if (!is_readable("/proc/cpuinfo"));
		$file = @file("/proc/cpuinfo");

		if (!$file) { return ""; }

		foreach ($file as $line) {
			list($key,$value) = split(":",$line);
			$key = trim($key);
			$value = trim($value);

			if (preg_match("/MHZ/i",$line)) {  
				$ret = "CPU: " . intval($value) . "mhz"; 
				return $ret;
			}
		}
	}

	public function benchmark($name) {
		$time = $this->get_microtime();
		$round = 4;

		// Sort them according to time, or show in the order they came in the code
		$sort = 0;

		$this->timer[] = array('name'=>$name,'time'=>$time);

		#print "$name<br />\n";

		if ($name == "stop") {
			#print "calc";
			#print_r($this->timer);

			$start = $this->timer[0]['time'];
			$stop = $this->timer[sizeof($this->timer) - 1]['time'];
			#print "1 $start 2 $stop";
			$total = round($stop - $start,$round);
			
			foreach ($this->timer as $data) {
				$name = $data['name'];
				$time = $data['time'];

				$diff = round($time - $prev,$round);

				if (!preg_match("/(start|stop)/",$name)) {
					$ret .= "$name: $diff seconds\n";
					$info["$diff"] = $name;
				}
				
				$prev = $time;
			}

			if ($sort) { 
				ksort($info);
				$ret = "";
				foreach(array_keys($info) as $key) {
					$name = $info[$key];

					$ret .= "$name: $key seconds\n";
				}
			}
				
			$ret .= "<b>Total:</b> $total seconds";
			
			return $ret;
		}
	}
}

?>
