DROP TABLE Counter;
CREATE TABLE Counter (
  CntID INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
  CntCount INTEGER,
  CntName VARCHAR(25)
);
CREATE UNIQUE INDEX CntName ON Counter(CntName);

DROP TABLE CounterLog;
CREATE TABLE CounterLog (
  LogID INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
  CntID INTEGER,
  LogHost VARCHAR(50),
  LogRefer VARCHAR(250),
  LogBrowser VARCHAR(50),
  LogBrowserVersion FLOAT,
  LogOS VARCHAR(30),
  LogOSVersion VARCHAR(10),
  LogTimeStamp INTEGER
);
CREATE INDEX LogTimeStamp ON CounterLog(LogTimeStamp);
CREATE INDEX CntID ON CounterLog(CntID);

GRANT ALL ON Counter.* TO gcount@'%' IDENTIFIED BY 'gcount';
GRANT ALL ON CounterLog.* TO gcount@'%' IDENTIFIED BY 'gcount';

FLUSH PRIVILEGES;
